/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.CustomRegisters;
import noppes.npcs.ModelPartData;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.entity.EntityCustomNpc;

public abstract class LayerInterface<T extends EntityLivingBase>
implements LayerRenderer<T> {
    public ModelBiped model;
    protected EntityCustomNpc npc;
    protected ModelData playerdata;
    protected RenderLiving<?> render;

    public LayerInterface(RenderLiving<?> renderIn) {
        this.render = renderIn;
        this.model = (ModelBiped)this.render.func_177087_b();
    }

    private int blend(int color1, int color2) {
        int aR = (color1 & 0xFF0000) >> 16;
        int aG = (color1 & 0xFF00) >> 8;
        int aB = color1 & 0xFF;
        int bR = (color2 & 0xFF0000) >> 16;
        int bG = (color2 & 0xFF00) >> 8;
        int bB = color2 & 0xFF;
        int R = (int)((float)aR + (float)(bR - aR) * 0.5f);
        int G = (int)((float)aG + (float)(bG - aG) * 0.5f);
        int B = (int)((float)aB + (float)(bB - aB) * 0.5f);
        return R << 16 | G << 8 | B;
    }

    public void func_177141_a(@Nonnull EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.npc = (EntityCustomNpc)entity;
        if (this.npc.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        this.playerdata = this.npc.modelData;
        if (!(this.render.func_177087_b() instanceof ModelBiped)) {
            return;
        }
        this.model = (ModelBiped)this.render.func_177087_b();
        this.rotate(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179094_E();
        if (entity.func_82150_aj()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        }
        if (!this.npc.animation.isAnimated(AnimationKind.DIES) && this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        }
        if (this.npc.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        GlStateManager.func_179091_B();
        this.render(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179101_C();
        if (entity.func_82150_aj()) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179121_F();
    }

    public void preRender(ModelPartData data) {
        if (data == null) {
            return;
        }
        if (data.playerTexture) {
            ClientProxy.bindTexture(this.npc.textureLocation);
        } else {
            ClientProxy.bindTexture(data.getResource());
        }
        if (!this.npc.animation.isAnimated(AnimationKind.DIES) && this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            return;
        }
        int color = data.color;
        if (this.npc.display.getTint() != 0xFFFFFF) {
            color = data.color != 0xFFFFFF ? this.blend(data.color, this.npc.display.getTint()) : this.npc.display.getTint();
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        boolean isInvisible = false;
        if (this.npc.display.getVisible() == 1) {
            isInvisible = this.npc.display.getAvailability().isAvailable((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        } else if (this.npc.display.getVisible() == 2) {
            boolean bl = isInvisible = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() != CustomRegisters.wand;
        }
        if (isInvisible) {
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)0.15f);
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
            GlStateManager.func_179084_k();
        }
    }

    public abstract void render(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract void rotate(float var1, float var2, float var3, float var4, float var5, float var6);

    public void setColor(ModelPartData ignoredData, EntityLivingBase ignoredEntity) {
    }

    public void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public boolean func_177142_b() {
        return false;
    }
}

